//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "audiomain_bcbx.h"
#include "audioc.h"
#include "reverb_wave.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TGUIForm *GUIForm;
//---------------------------------------------------------------------------
__fastcall TGUIForm::TGUIForm(TComponent* Owner)
	: TForm(Owner)
{
   AudioInUse=false;
   Wav=NULL;
   newwave=NULL;
}


//---------------------------------------------------------------------------
void __fastcall TGUIForm::SpeedButton1Click(TObject *Sender)
{
	if (OpenDialog->Execute())
    {
       // attempt to create a wave object
       Wav=new AudioC(OpenDialog->FileName.c_str());
       if (Wav!=NULL) InFileEdit->Text=OpenDialog->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TGUIForm::ProcessBtnClick(TObject *Sender)
{


   // create new wave object based on old one
   newwave= new AudioC(*Wav);


   reverb_wav(*Wav,StrToFloat(RevDelEdit->Text),
              StrToFloat(RevAmpEdit->Text),*newwave);
}

//---------------------------------------------------------------------------
void __fastcall TGUIForm::SpeedButton2Click(TObject *Sender)
{
	if (SaveDialog->Execute())
    {
       OutFileEdit->Text=SaveDialog->FileName;
    }
}
//---------------------------------------------------------------------------
void __fastcall TGUIForm::QuitBtnClick(TObject *Sender)
{
    Application->Terminate();
}
//---------------------------------------------------------------------------
void __fastcall TGUIForm::SaveBtnClick(TObject *Sender)
{
   newwave->WriteFile(OutFileEdit->Text.c_str());

}
//---------------------------------------------------------------------------
void __fastcall TGUIForm::FormDestroy(TObject *Sender)
{
	if (Wav!=NULL) delete Wav;
    if (newwave!=NULL) delete newwave;
}
//---------------------------------------------------------------------------
